﻿# ******************************************************************************************
#	KnifeP3N Python
#		by Schubaal
#		5.1.0
#
# * Description:
#	- when there's only one player left on each team, knife battles ensue!
#
# * Install instructions:
#			1. Install Mattie's EventScripts 2+:
#				http://mattie.info/cs
#
#			2. Extract the file [knifep3n.zip] to your /cstrike/ directory:
#				/addons/eventscripts/knifep3n/knifep3n.py
#				/cfg/knifep3n/knifep3n.cfg
#				/cfg/knifep3n/strings.ini
#				/sound/ql/chicken.wav
#				/sound/schu/beacon.wav
#
#			3. Add the following line somewhere in autoexec.cfg or server.cfg:
#				es_load knifep3n
#
#			4. Adjust any settings in the class KnifeP3N_Settings below.
#
# ******************************************************************************************
# 	TRANSLATION CREDITS
#***************************
#	en: 	Schubaal
#	fr: 	L'In20Cible
#	de:	SebiTimeWaster
#	ru:	Cheburator259
#	pl:	Arcy
#
# ******************************************************************************************

import es
import popuplib
import playerlib
import random
import services
import gamethread
import weaponlib
import string
import langlib
import os

knifep3nVersion = "5.1.0"
versionDate = "2010-02-28 09:02 EST"
es.set('knifep3n', knifep3nVersion)
es.makepublic('knifep3n')

info = es.AddonInfo()
info.name		 = "KnifeP3N Python"
info.version	 = knifep3nVersion
info.url		 = "http://forums.mattie.info/cs/forums/viewtopic.php?t=19090"
info.basename	 = "knifep3n"
info.author		 = "Schubaal"
info.description = "Based on the ESClassic script by P3N."

class knifep3n_Settings:
	def __init__(self):
		self.var = {}
		self.loadCfg()
	
	def loadCfg(self):
		self.path = '%s/cfg/knifep3n/knifep3n.cfg'%(str(es.ServerVar('eventscripts_gamedir')).replace('\\', '/'))
		try:
			configFile = open(self.path, 'r')
		except IOError, e:
			raise FileError('Unable to load KnifeP3N config: %s' % e)
			es.unload('knifep3n')
		lines = map(lambda x: x.strip().lower(), configFile.readlines())
		lines = filter(lambda x: x and (not x.startswith('//')), lines)
		configFile.close()
		for line in lines:
			if line.startswith('//'):
				continue
			while '	' in line:
				# remove tabs
				line = line.replace('	',' ')
			while '  ' in line:
				#remove all but one space (as delimiter)
				line = line.replace('  ',' ')
			if line.count(' ') < 1:
				es.dbgmsg(0, "KnifeP3N Config: Missing Value: %s"%line.split(' ')[0])
				self.var[line.split(' ')[0]] = ""
				continue
			vName, vValue = line.split(' ', 1)
			if vName in self.var:
				if vValue != self.var[vName]:
					es.dbgmsg(0, "KnifeP3N Config: Setting %s changed from %s to %s"%(vName,self.var[vName],vValue))
			try:
				self.var[vName] = int(vValue)
			except ValueError:
				self.var[vName] = vValue
			es.dbgmsg(1, vName+": "+str(self.var[vName]))

class EsToolsWrapper:
	def beacon(self, userid):
		x, y, z = playerlib.getPlayer(userid).get('location')
		z = z+10
		team = playerlib.getPlayer(userid).team
		if team == 2:
			es.server.cmd('es est_effect 10 #a 0 "sprites/lgtning.vmt" '+str(x)+' '+str(y)+' '+str(z)+' 1 '+str(settings.var['beacon_size'])+' 1 10 50 0 '+str(settings.var['t_beacon'])+' 200 0')
		elif team == 3:
			es.server.cmd('es est_effect 10 #a 0 "sprites/lgtning.vmt" '+str(x)+' '+str(y)+' '+str(z)+' 1 '+str(settings.var['beacon_size'])+' 1 10 50 0 '+str(settings.var['ct_beacon'])+' 200 0')
		else:
			es.msg('#multi',knifep3n_msg+"This message shouldn't ever be sent.")

if es.exists('variable', 'est_version'):
	est = EsToolsWrapper()
else:
	est = 0

class knifep3n_Player:
	def __init__(self,userid):
		self.userid = int(userid)
		self.Player = playerlib.getPlayer(userid)
		if settings.var['keep_weapons']:
			self.weaponPrimary = self.Player.getPrimary()
			self.weaponSecondary = self.Player.getSecondary()
			self.weaponHE = self.Player.getHE()
			self.weaponFlash = self.Player.getFB()
			self.weaponSmoke = self.Player.getSG()
			self.weaponDefuse = self.Player.hasDefuser()
			self.weaponArmor = self.Player.getArmor()
			self.weaponHelmet = self.Player.hasHelmet()

knifep3n_msg = "#default[#greenKnifeP3N#default]#lightgreen "

class knifep3n_Message():
	def __init__(self):
		dir = str(es.ServerVar('eventscripts_gamedir')).replace('\\', '/')+'/cfg/knifep3n/strings.ini'
		self.strings = langlib.Strings(dir)
	
	def send(self, message, filter=0, tokens={}):
		if filter >= settings.var['chat_filter']:
			try:
				str = self.strings(message, tokens, settings.var['lang'])
			except (KeyError, AttributeError):
				str = self.strings(message, tokens)
			es.msg('#multi', knifep3n_msg+str)
	
	def tell(self, userid, message, tokens={}):
		try:
			str = self.strings(message, tokens, settings.var['lang'])
		except (KeyError, AttributeError):
			str = self.strings(message, tokens)
		es.tell(userid, '#multi', knifep3n_msg+str)

msg = knifep3n_Message()

######################
# Status works in phases:
status = 0
# 0 = not started
# 1 = popup sent
# 2 = player 1 voted yes
# 3 = both players voted
# 4 = fight in progress
# 5 = player voted no
# 6 = fight over
######################
settings = knifep3n_Settings()
player1 = 0
player2 = 0
winner = 0
lame = []

def player_vote(userid,pchoice,pname):
	if pchoice == 1:
		vote_yes(userid)
	if pchoice == 2:
		vote_no(userid)

# Vote menu
menu = popuplib.create('knifep3n_menu')
menu.addline("		 Knife fight?", 'en')
menu.addlineAll('------------------------------')
menu.addline("->1. Yes, of course!", 'en')
menu.addline("->2. No, I'm a chicken...", 'en')
menu.addlineAll('------------------------------')
menu.select(1,player_vote)
menu.select(2,player_vote)

def typevote_yes():
	if status > 0 and status < 4:
		vote_yes(es.getcmduserid())

def load():
	'''
	Loads KnifeP3N assist scripts, sets popup menu, runs init
	'''
	init()
	es.server.cmd('clientcmd create say @kp_force knifep3n/kp_force "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_reload knifep3n/kp_reload "knifep3n" #admin')
	es.regsaycmd('!yes', typevote_yes)
	msg.send('loaded', 2, {'knifep3nVersion': knifep3nVersion})


def unload():
	'''
	clears the popup
	'''
	menu.unsend(playerlib.getUseridList('#all'))
	popuplib.delete('knifep3n_menu')
	es.unregsaycmd('@kp_force')
	es.unregsaycmd('@kp_reload')
	es.unregsaycmd('!yes')

def es_map_start(event_var):
	'''
	Simply runs init
	'''
	init()
	kp_reset()

def init():
	'''
	Sets downloadables
	'''
	# Load sounds into downloadables
	if settings.var['beacon_sound'] != "":
		es.stringtable('downloadables', 'sound/'+settings.var['beacon_sound'])
	if settings.var['sounds_yes'] != "":
		es.stringtable('downloadables', 'sound/'+settings.var['sounds_yes'])
	if settings.var['sounds_no'] != "":
		es.stringtable('downloadables', 'sound/'+settings.var['sounds_no'])
	if settings.var['sounds_start'] != "":
		if (',' in settings.var['sounds_start']):
			parts = settings.var['sounds_start'].split(',')
			for k in parts:
				es.stringtable('downloadables', 'sound/'+str(k))
		else:
			es.stringtable('downloadables', 'sound/'+settings.var['sounds_start'])
	if settings.var['sounds_winner'] != "":
		if (',' in settings.var['sounds_winner']):
			for k in parts:
				es.stringtable('downloadables', 'sound/'+str(k))
		else:
			es.stringtable('downloadables', 'sound/'+settings.var['sounds_winner'])

def kp_reload():
	'''
	Loads settings from knifep3n.cfg without reloading the addon
	'''
	if not status:
		settings.loadCfg()
		msg.tell(es.getcmduserid(), 'admin_reload_done')
	else:
		msg.tell(es.getcmduserid(), 'admin_reload_halt')

def kp_force():
	'''
	Forces a knife fight if there is exactly one player alive on each team and
		a fight has not already occurred.
	'''
	global status
	userid = es.getcmduserid()
	if status != 3 and status != 4 and status != 6:
		uname = es.getplayername(userid)
		if not settings.var['no_vote']:
			if es.getlivingplayercount(2) == 1 and es.getlivingplayercount(3) == 1:
				msg.send('kp_force', 1, {'admin': uname})
				menu.unsend(playerlib.getUseridList('#all'))
				status = 3
				force_fight()
			else:
				msg.tell(userid, 'admin_toomanyplayers')
		else:
			msg.tell(userid, 'admin_novote')
	else:
		msg.tell(userid, 'admin_toolate')


def round_start(event_var):
	'''
	1.) Gives rewards to winner
	2.) If enabled, gives previous equipment to winner
	3.) If resilience is not enabled, clears the winner
	4.) Sets lame player health and clears lame list.
	5.) Ensures tracking variables are reset.
	'''
	global winner, lame
	if winner:
		if settings.var['award_money']:
			x = winner.Player.getCash() + int(settings.var['bonus_money'])
			if x > 16000:
				x = 16000
			winner.Player.setCash(x)
		if settings.var['award_health']:
			if winner.Player.health:
				x = winner.Player.health + int(settings.var['bonus_health'])
			else:
				x = 100 + settings.var['bonus_health']
			winner.Player.health = x
		if settings.var['award_speed']:
			if winner.Player.speed:
				x = winner.Player.getSpeed() + float(settings.var['bonus_speed'])
			else:
				x = 1.0 + settings.var['bonus_speed']
			winner.Player.setSpeed(x)
		if settings.var['keep_weapons']:
			es.server.cmd('es_xgive %s player_weaponstrip'%str(winner.userid))
			es.server.cmd('es_xfire %s player_weaponstrip Strip 1'%str(winner.userid))
			es.give(winner.userid, 'weapon_knife')
			if winner.weaponPrimary:
				es.give(winner.userid, 'weapon_'+winner.weaponPrimary)
			if winner.weaponSecondary:
				es.give(winner.userid, 'weapon_'+winner.weaponSecondary)
			if winner.weaponHE:
				winner.Player.setHE(winner.weaponHE)
			if winner.weaponHelmet:
				es.give(winner.userid, 'item_assaultsuit')
			elif winner.weaponArmor:
				es.give(winner.userid, 'item_kevlar')
			if winner.weaponFlash:
				winner.Player.setFB(winner.weaponFlash)
			if winner.weaponSmoke:
				winner.Player.setSG(winner.weaponSmoke)
			if winner.weaponDefuse:
				winner.Player.setDefuser(1)
		if not settings.var['resilience']:
			winner = 0
	if lame:
		for userid in lame:
			player = playerlib.getPlayer(userid)
			player.health = settings.var['lame_health']
		lame = []
	kp_reset()

def kp_reset():
	'''
	Resets tracking variables and unsends the vote menu
	'''
	global status, player1, player2
	status, player1, player2 = 0,0,0
	menu.unsend(playerlib.getUseridList('#all'))

def bot_vote(botid):
	if settings.var['bot_vote']:
		i = random.randint(1,settings.var['bot_vote'])
		if settings.var['bot_vote'] == i:
			vote_yes(botid)
		else:
			vote_no(botid)
	else:
		vote_no(botid)

def vote_yes(userid):
	global player1, player2, status
	if settings.var['sounds_yes'] != "":
		if string.find(settings.var['sounds_yes'], ','):
			sounds = string.split(settings.var['sounds_yes'], ',')
			x = len(sounds)
			y = random.randint(0, x-1)
			es.cexec_all("play",sounds[y])
		else:
			es.cexec_all("play",settings.var['sounds_yes'])
	if not player1:
		player1 = knifep3n_Player(userid)
		msg.send('accepted', 1, {'player': player1.Player.name})
		status = 2
	else:
		player2 = knifep3n_Player(userid)
		status = 3
		prep_fight()

def chicken_punish(userid):
	player = playerlib.getPlayer(userid)
	if settings.var['chicken_color'] != "":
		r,g,b = string.split(settings.var['chicken_color'],' ')
		player.setColor(r,g,b)
	if settings.var['chicken_speed']:
		if winner:
			if winner.userid == userid:
				x = winner.Player.getSpeed() - settings.var['bonus_speed']
				winner.Player.setSpeed(x)
		x = player.getSpeed() + settings.var['chicken_speed']
		player.setSpeed(x)

def vote_no(userid):
	msg.send('chicken', 0, {'player': es.getplayername(userid)})
	if settings.var['sounds_no'] != "":
		if string.find(settings.var['sounds_no'], ','):
			sounds = string.split(settings.var['sounds_no'], ',')
			x = len(sounds)
			y = random.randint(0, x-1)
			es.cexec_all("play",sounds[y])
		else:
			es.cexec_all("play",settings.var['sounds_no'])
	if settings.var['punishment']:
		chicken_punish(userid)
	kp_reset()

def force_fight():
	global player1, player2
	player1 = 0
	player2 = 0
	for userid in playerlib.getUseridList('#alive'):
		if not player1:
			player1 = knifep3n_Player(userid)
			es.dbgmsg(0,knifep3n_msg+"Player 1 is %s"%player1.Player.name)
		else:
			player2 = knifep3n_Player(userid)
			es.dbgmsg(0,knifep3n_msg+"Player 2 is %s"%player2.Player.name)
	prep_fight()

def prep_fight():
	global status
	player1.Player.set('health', settings.var['fight_health'])
	player2.Player.set('health', settings.var['fight_health'])
	player1.Player.set('speed', 1.0)
	player2.Player.set('speed', 1.0)
	strip_weapons()
	if settings.var['teleport']:
		x,y,z = player1.Player.get('location')
		start_teleport(x,y,z,player1.userid)
	else:
		start_fight_init()

def strip_weapons():
	for index in weaponlib.getIndexList('#all'):
		es.server.cmd('es_xremove %s' % index)
	for player in playerlib.getUseridList('#alive'):
		gamethread.delayed(0.05, es.server.cmd, 'es_xgive %s item_assaultsuit'%str(player))
		gamethread.delayed(0.05, es.server.cmd, 'es_xgive %s weapon_knife'%str(player))
		es.delayed(0.1, es.sexec(player, 'use weapon_knife'))

def player_slap():
	player1.Player.set('health', 500)
	player1.Player.push(random.randint(500,600), random.randint(250,350), 1)

def start_teleport(x,y,z,userid):
	if settings.var['slap']:
		player_slap()
	es.centermsg(msg.strings('teleport', {'seconds': 3, 'player': player2.Player.name}))
	gamethread.delayed(1, es.centermsg, (msg.strings('teleport', {'seconds': 2, 'player': player2.Player.name})))
	gamethread.delayed(2, es.centermsg, (msg.strings('teleport1', {'player': player2.Player.name})))
	gamethread.delayed(3, player_teleport, (x,y,z))
	gamethread.delayed(3, start_fight_init)

def player_teleport(x,y,z):
	es.server.cmd('es_xsetpos %s %s %s %s' % (player2.userid, x, y, z))
	player1.Player.viewPlayer(player2.userid)
	player2.Player.viewPlayer(player1.userid)

def beacon(userid):
	if status == 4:
		if est:
			est.beacon(userid)
		if settings.var['beacon_sound'] != "":
			es.emitsound("player", userid, settings.var['beacon_sound'], 1.0, 0.7)
		gamethread.delayed(float(settings.var['beacon_rate']), beacon, userid)

def start_fight_init():
	global status
	status = 4
	if settings.var['sounds_start'] != "":
		if string.find(settings.var['sounds_start'], ','):
			sounds = string.split(settings.var['sounds_start'], ',')
			x = len(sounds)
			y = random.randint(0, x-1)
			es.cexec_all("play",sounds[y])
		else:
			es.cexec_all("play",settings.var['sounds_start'])
	if settings.var['beacon']:
		beacon(player1.userid)
		gamethread.delayed(float(settings.var['beacon_rate'])/2, beacon, player2.userid)
	player1.Player.set('health', settings.var['fight_health'])
	player2.Player.set('health', settings.var['fight_health'])
	strip_weapons()
	gamethread.delayed(0.15, start_fight, settings.var['timer'])

def start_fight(timer):
	if timer and (status == 4):
		es.centermsg(msg.strings('fight_counter', {'seconds': timer}))
		timer = timer - 1
		gamethread.delayed(1, start_fight, timer)
	elif not timer and status != 5:
		fight_timeout()
	elif timer and (status >= 5):
		return
	else:
		es.msg('#multi',knifep3n_msg+'An error occured, tell Schubaal "status was 0 and timer was not"')

def fight_timeout():
	if player1.Player.health > player2.Player.health:
		es.sexec(player2.userid,"kill")
	elif player2.Player.health > player1.Player.health:
		es.sexec(player1.userid,"kill")
	else:
		msg.send('whyfight', 1)
		es.sexec(player1.userid,"kill")
		es.sexec(player2.userid,"kill")
		gamethread.delayed(0, kp_reset)

def player_death(event_var):
	global status, winner
	if status == 6:
		kp_reset()
	elif (status == 0 and es.getlivingplayercount(2) == 1 and es.getlivingplayercount(3) == 1):
		if not settings.var['no_vote']:
			msg.send('voting', 0)
			botList = playerlib.getUseridList('#alive,#bot')
			for botid in botList:
				bot_vote(botid)
			userList = playerlib.getUseridList('#alive,#human')
			for userid in userList:
				menu.send(userid)
			status = 1
		else:
			status = 3
			msg.send('forced', 0)
			force_fight()
	elif (status == 1 or status == 2):
		kp_reset()
	elif (status == 4):
		status = 6
		if event_var['attacker'] == event_var['userid']:
			msg.send('suicide', 1, {'player': es.getplayername(event_var['attacker'])})
			lame.append(event_var['attacker'])
		else:
			if settings.var['sounds_winner'] != "":
				if string.find(settings.var['sounds_winner'], ','):
					sounds = string.split(settings.var['sounds_winner'], ',')
					x = len(sounds)
					y = random.randint(0, x-1)
					es.cexec_all("play",sounds[y])
				else:
					es.cexec_all("play",settings.var['sounds_winner'])
			if (player1.userid == int(event_var['attacker'])):
				msg.send('won', 1, {'player': player1.Player.name})
				winner = player1
			else:
				msg.send('won', 1, {'player': player2.Player.name})
				winner = player2
	elif (status == 3):
		status = 6
		if event_var['attacker'] == event_var['userid']:
			msg.send('suicide', 1, {'player': es.getplayername(event_var['attacker'])})
			lame.append(event_var['attacker'])
		else:
			msg.send('cheated_early', 1, {'player': es.getplayername(event_var['attacker'])})
			es.sexec(event_var['attacker'],"kill")

def player_disconnect(event_var):
	global status
	if status == 3 or status == 5:
		if event_var['userid'] == player1.userid or event_var['userid'] == player2.userid:
			status = 6

def item_pickup(event_var):
	if status > 2 and status < 5:
		if event_var['item'] != 'knife':
			player = playerlib.Player(event_var['userid'])
			index = player.getWeaponIndex(event_var['item'])
			es.server.cmd('es_xremove %s' % index)
			es.sexec(event_var['userid'], 'use weapon_knife')

def player_spawn(event_var):
	if status > 0 and status < 5:
		msg.send('inprogress', 0, {'player': es.getplayername(event_var['userid'])})
		es.sexec(event_var['userid'],"kill")